%% Description
% Plots figure 10: profiles showing dimple formation.
%
% The solution is evolved numerically from an initially flat state at t=0
% with the parameters \Gamma = 100, H_\infty = 5. We plot the solution
% profiles at times t = [0 1e-2 1e-1 1e0 1e1 1e2], showing the formation 
% of the fluid-filled dimple under the membrane.

%% Parameter Definitions
%
% G     Value of \Gamma.
%
% Hinf  Value of H_\infty
%
% t     The timepoints to be plotted
%
% z     The spatial discretization
%
% h     The membrane height profile at the 6 different times:
%                   h_i,j = h(t(i),z(j))
%
% rM    The radial position of the meniscus at each time

clear all;close all;


%% Load data
load('figure10.mat')

%% Plotting
cols=parula(10);
for i = 1:6
    
subplot(3,2,i)

plot(rM(i).*z',h(i,:),'-','color','red','LineWidth',2); hold on;
plot(-rM(i).*z',h(i,:),'-','color','red','LineWidth',2); hold on;
x = linspace(rM(i),1);
plot(x, (h(i,end)- Hinf).*log(x)./log(rM(i)) + Hinf,'-','color','red','LineWidth',2);
plot(-x, (h(i,end)- Hinf).*log(x)./log(rM(i)) + Hinf,'-','color','red','LineWidth',2);

y0 = zeros(1,length(z));
fill([rM(i).*z rM(i).*fliplr(z) -rM(i).*z -rM(i).*fliplr(z)],[h(i,:) y0 y0 fliplr(h(i,:))],cols(3,:));
axis([-1 1 0 5])
hold off

set(gca,'xtick',[])
set(gca,'ytick',[])

end

